/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.cdmiswift;

import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.api.storage.StorageTimeoutException;
import com.intel.cosbench.client.cdmiswift.CdmiSwiftClient;
import com.intel.cosbench.client.cdmiswift.CdmiSwiftClientException;
import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import org.apache.http.client.HttpClient;

public class CDMIStorage
extends NoneStorage {
    private CdmiSwiftClient client;
    private int timeout;
    private String rootPath;
    private String storageUrl;

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.initParms(config);
        HttpClient httpClient = HttpClientUtil.createHttpClient((int)this.timeout);
        this.client = new CdmiSwiftClient(httpClient);
    }

    private void initParms(Config config) {
        this.rootPath = config.get("root_path", "/cdmi");
        this.storageUrl = config.get("storage_url", "http://127.0.0.1:8080/cdmi");
        this.timeout = config.getInt("timeout", 30000);
        this.parms.put("root_path", (Object)this.rootPath);
        this.parms.put("storage_url", (Object)this.storageUrl);
        this.parms.put("timeout", (Object)this.timeout);
    }

    public void setAuthContext(AuthContext info) {
        super.setAuthContext(info);
        try {
            String authToken = info.getStr("token");
            String storageUrl = info.getStr("storage_url");
            this.logger.debug("auth token=" + authToken + ", storage url=" + storageUrl);
            this.client.init(authToken, storageUrl);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void dispose() {
        super.dispose();
        this.client.dispose();
    }

    public InputStream getObject(String container, String object, Config config) {
        InputStream stream;
        super.getObject(container, object, config);
        try {
            stream = this.client.getObjectAsStream(container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (CdmiSwiftClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        return stream;
    }

    public void createContainer(String container, Config config) {
        super.createContainer(container, config);
        try {
            this.client.createContainer(container);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (CdmiSwiftClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void createObject(String container, String object, InputStream data, long length, Config config) {
        super.createObject(container, object, data, length, config);
        try {
            this.client.storeStreamedObject(container, object, data, length);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (CdmiSwiftClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteContainer(String container, Config config) {
        super.deleteContainer(container, config);
        try {
            this.client.deleteContainer(container);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (CdmiSwiftClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteObject(String container, String object, Config config) {
        super.deleteObject(container, object, config);
        try {
            this.client.deleteObject(container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (CdmiSwiftClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }
}

