/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.tomcat.osgi;

import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.tomcat.TomcatLoader;
import com.intel.cosbench.tomcat.TomcatRegister;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private BundleContext context;
    private TomcatLoader loader;
    private TomcatRegister register;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        Thread curr = Thread.currentThread();
        ClassLoader backup = curr.getContextClassLoader();
        try {
            try {
                curr.setContextClassLoader(Activator.class.getClassLoader());
                this.doStart();
            }
            catch (Exception e) {
                LOGGER.error("fail to start and publish tomcat service", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        finally {
            curr.setContextClassLoader(backup);
        }
        LOGGER.info("tomcat service has been started and published");
    }

    private void doStart() {
        this.loader = new TomcatLoader();
        this.loader.start();
        this.register = new TomcatRegister();
        this.register.publishService(this.context, this.loader.getService());
    }

    public void stop(BundleContext context) throws Exception {
        Thread curr = Thread.currentThread();
        ClassLoader backup = curr.getContextClassLoader();
        try {
            try {
                curr.setContextClassLoader(Activator.class.getClassLoader());
                this.doStop();
            }
            catch (Exception e) {
                LOGGER.error("fail to unpublish and stop tomcat server", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        finally {
            curr.setContextClassLoader(backup);
        }
        LOGGER.info("tomcat service has been unpublished and stopped");
    }

    private void doStop() {
        this.register.unpublishService();
        this.register = null;
        this.loader.stop();
        this.loader = null;
        this.context = null;
    }
}

