/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.tomcat;

import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.io.File;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.startup.Catalina;
import org.apache.commons.lang.SystemUtils;

public class TomcatLoader
extends Catalina {
    private static final String CFG_FILE_KEY = "cosbench.tomcat.config";
    private static final String UNIX_DEFAULT_CFG_FILE = "/etc/cosbench/tomcat-server.xml";
    private static final String WIN_DEFAULT_CFG_FILE = "C:\\tomcat-server.xml";
    private static final Logger LOGGER = LogFactory.getSystemLogger();

    public TomcatLoader() {
        this.setName("Catalina");
        this.setAwait(false);
        this.setConfig(TomcatLoader.getServerConfig());
        this.setUseShutdownHook(false);
        this.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        LOGGER.info("using tomcat configuration defined in {}", (Object)this.configFile);
    }

    private static String getServerConfig() {
        String configFile = System.getProperty(CFG_FILE_KEY);
        if (configFile != null) {
            return configFile;
        }
        if (new File("tomcat-server.xml").exists()) {
            return "tomcat-server.xml";
        }
        if (new File("conf/tomcat-server.xml").exists()) {
            return "conf/tomcat-server.xml";
        }
        return SystemUtils.IS_OS_WINDOWS ? WIN_DEFAULT_CFG_FILE : UNIX_DEFAULT_CFG_FILE;
    }

    public void start() {
        super.start();
        StandardService service = this.getService();
        Connector[] connectorArray = service.findConnectors();
        int n = connectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connector connector = connectorArray[n2];
            TomcatLoader.printToConsole(connector.getPort());
            ++n2;
        }
    }

    private static void printToConsole(int port) {
        System.err.println("----------------------------------------------");
        String msg = "!!! Service will listen on web port: " + port + " !!!";
        System.err.println(msg);
        System.err.println("----------------------------------------------");
    }

    public StandardService getService() {
        Service[] services = this.server.findServices();
        if (services == null || services.length == 0) {
            throw new RuntimeException("invalid tomcat config: non service defined");
        }
        if (services.length != 1) {
            throw new RuntimeException("invalid tomcat config: multiple services");
        }
        return (StandardService)this.server.findServices()[0];
    }
}

