/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.librados;

import com.ceph.rados.IoCTX;
import com.ceph.rados.Rados;
import com.ceph.rados.exceptions.RadosAlreadyConnectedException;
import com.ceph.rados.exceptions.RadosException;
import com.ceph.rados.exceptions.RadosOperationInProgressException;
import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LibradosStorage
extends NoneStorage {
    private String accessKey;
    private String secretKey;
    private String endpoint;
    private static Rados client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.endpoint = config.get("endpoint", "127.0.0.1");
        this.accessKey = config.get("accesskey", "");
        this.secretKey = config.get("secretkey", "");
        this.parms.put("endpoint", (Object)this.endpoint);
        this.parms.put("accesskey", (Object)this.accessKey);
        this.parms.put("secretkey", (Object)this.secretKey);
        logger.debug("using storage config: {}", (Object)this.parms);
        try {
            if (client == null) {
                Class<?> clazz = ((Object)((Object)this)).getClass();
                synchronized (clazz) {
                    if (client == null) {
                        client = new Rados(this.accessKey);
                        client.confSet("key", this.secretKey);
                        client.confSet("mon_host", this.endpoint);
                        client.connect();
                        logger.info("Librados client has connected.");
                    }
                }
            }
            logger.debug("Librados client has been initialized");
        }
        catch (RadosAlreadyConnectedException radosAlreadyConnectedException) {
            logger.debug("The connection is already connected");
        }
        catch (RadosOperationInProgressException radosOperationInProgressException) {
            logger.warn("Connection is in progress");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                throw new StorageException((Throwable)ie);
            }
        }
        catch (RadosException e) {
            logger.error(e.getMessage());
            throw new StorageException((Throwable)e);
        }
    }

    public void setAuthContext(AuthContext info) {
        super.setAuthContext(info);
    }

    public void dispose() {
        super.dispose();
    }

    public InputStream getObject(String container, String object, Config config) {
        ByteArrayInputStream stream;
        super.getObject(container, object, config);
        IoCTX ioctx = null;
        try {
            try {
                ioctx = client.ioCtxCreate(container);
                long length = ioctx.stat(object).getSize();
                if ((double)length > Math.pow(2.0, 31.0) - 1.0) {
                    throw new StorageException("Object larger than 2GB, handling not implemented");
                }
                byte[] buf = new byte[(int)length];
                ioctx.read(object, (int)length, 0L, buf);
                stream = new ByteArrayInputStream(buf);
            }
            catch (RadosException e) {
                throw new StorageException((Throwable)e);
            }
        }
        finally {
            if (ioctx != null) {
                client.ioCtxDestroy(ioctx);
            }
        }
        return stream;
    }

    public void createContainer(String container, Config config) {
        super.createContainer(container, config);
        try {
            boolean exists = false;
            String[] stringArray = client.poolList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pool = stringArray[n2];
                if (pool.equals(container)) {
                    exists = true;
                }
                ++n2;
            }
            if (!exists) {
                client.poolCreate(container);
            }
        }
        catch (RadosException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteContainer(String container, Config config) {
        super.deleteContainer(container, config);
        try {
            client.poolDelete(container);
        }
        catch (RadosException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void createObject(String container, String object, InputStream data, long length, Config config) {
        super.createObject(container, object, data, length, config);
        byte[] buf = new byte[(int)length];
        IoCTX ioctx = null;
        try {
            try {
                data.read(buf, 0, (int)length);
                ioctx = client.ioCtxCreate(container);
                ioctx.write(object, buf);
            }
            catch (RadosException e) {
                throw new StorageException((Throwable)e);
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (ioctx != null) {
                client.ioCtxDestroy(ioctx);
            }
            throw throwable;
        }
        if (ioctx != null) {
            client.ioCtxDestroy(ioctx);
        }
    }

    public void deleteObject(String container, String object, Config config) {
        super.deleteObject(container, object, config);
        IoCTX ioctx = null;
        try {
            try {
                ioctx = client.ioCtxCreate(container);
                ioctx.remove(object);
            }
            catch (RadosException e) {
                throw new StorageException((Throwable)e);
            }
        }
        finally {
            if (ioctx != null) {
                client.ioCtxDestroy(ioctx);
            }
        }
    }
}

