/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.S3Stor;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import java.io.InputStream;

public class S3Storage
extends NoneStorage {
    private int timeout;
    private String accessKey;
    private String secretKey;
    private String endpoint;
    private AmazonS3 client;

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.timeout = config.getInt("timeout", 30000);
        this.parms.put("timeout", (Object)this.timeout);
        this.endpoint = config.get("endpoint", "http://s3.amazonaws.com");
        this.accessKey = config.get("accesskey", "");
        this.secretKey = config.get("secretkey", "");
        boolean pathStyleAccess = config.getBoolean("path_style_access", false);
        int maxConnections = config.getInt("max_connections", 50);
        String proxyHost = config.get("proxyhost", "");
        String proxyPort = config.get("proxyport", "");
        this.parms.put("endpoint", (Object)this.endpoint);
        this.parms.put("accesskey", (Object)this.accessKey);
        this.parms.put("secretkey", (Object)this.secretKey);
        this.parms.put("path_style_access", (Object)pathStyleAccess);
        this.parms.put("max_connections", (Object)maxConnections);
        this.parms.put("proxyhost", (Object)proxyHost);
        this.parms.put("proxyport", (Object)proxyPort);
        this.initClient();
    }

    private AmazonS3 initClient() {
        this.logger.debug("initialize S3 client with storage config: {}", (Object)this.parms);
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setConnectionTimeout(this.parms.getInt("timeout"));
        clientConf.setMaxConnections(this.parms.getInt("max_connections"));
        clientConf.setSocketTimeout(this.timeout);
        clientConf.withUseExpectContinue(false);
        clientConf.withSignerOverride("S3SignerType");
        if (!this.parms.getStr("proxyhost").equals("") && !this.parms.getStr("proxyport").equals("")) {
            clientConf.setProxyHost(this.parms.getStr("proxyhost"));
            clientConf.setProxyPort(this.parms.getInt("proxyport"));
        }
        BasicAWSCredentials myCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        this.client = new AmazonS3Client((AWSCredentials)myCredentials, clientConf);
        this.client.setEndpoint(this.endpoint);
        this.client.setS3ClientOptions(new S3ClientOptions().withPathStyleAccess(this.parms.getBoolean("path_style_access")));
        this.logger.debug("S3 client has been initialized");
        return this.client;
    }

    public void setAuthContext(AuthContext info) {
        super.setAuthContext(info);
    }

    public void dispose() {
        super.dispose();
        this.client = null;
    }

    public InputStream getObject(String container, String object, Config config) {
        super.getObject(container, object, config);
        S3ObjectInputStream stream = null;
        try {
            S3Object s3Obj = this.client.getObject(container, object);
            stream = s3Obj.getObjectContent();
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() != 404) {
                throw new StorageException((Throwable)ase);
            }
        }
        catch (AmazonClientException ace) {
            this.logger.warn("below exception encountered when retrieving object " + object + " at bucket " + container + ": " + ace.getMessage());
            ace.printStackTrace();
            this.initClient();
        }
        return stream;
    }

    public void createContainer(String container, Config config) {
        super.createContainer(container, config);
        try {
            if (!this.client.doesBucketExist(container)) {
                this.client.createBucket(container);
            }
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() != 404) {
                throw new StorageException((Throwable)ase);
            }
        }
        catch (AmazonClientException ace) {
            this.logger.warn("below exception encountered when creating bucket " + container + ": " + ace.getMessage());
            ace.printStackTrace();
            this.initClient();
        }
    }

    public void createObject(String container, String object, InputStream data, long length, Config config) {
        super.createObject(container, object, data, length, config);
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(length);
            metadata.setContentType("application/octet-stream");
            this.client.putObject(container, object, data, metadata);
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() != 404) {
                throw new StorageException((Throwable)ase);
            }
        }
        catch (AmazonClientException ace) {
            this.logger.warn("below exception encountered when creating object " + object + " at " + container + ": " + ace.getMessage());
            ace.printStackTrace();
            this.initClient();
        }
    }

    public void deleteContainer(String container, Config config) {
        super.deleteContainer(container, config);
        try {
            if (this.client.doesBucketExist(container)) {
                this.client.deleteBucket(container);
            }
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() != 404) {
                throw new StorageException((Throwable)ase);
            }
        }
        catch (AmazonClientException ace) {
            this.logger.warn("below exception encountered when deleting bucket " + container + ": " + ace.getMessage());
            ace.printStackTrace();
            this.initClient();
        }
    }

    public void deleteObject(String container, String object, Config config) {
        super.deleteObject(container, object, config);
        try {
            this.client.deleteObject(container, object);
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() != 404) {
                throw new StorageException((Throwable)ase);
            }
        }
        catch (AmazonClientException ace) {
            this.logger.warn("below exception encountered when deleting object " + object + " at bucket " + container + ": " + ace.getMessage());
            ace.printStackTrace();
            this.initClient();
        }
    }
}

