/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.cdmi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;

public class CdmiJsonInputStreamEntity
extends AbstractHttpEntity {
    private static final int BUFFER_SIZE = 2048;
    private InputStream content;
    private long length;
    private long transferLen;
    private TreeMap<String, String> data = new TreeMap();
    private TreeMap<String, String> metadata = new TreeMap();

    public CdmiJsonInputStreamEntity() {
        this.content = null;
        this.length = -1L;
        this.transferLen = -1L;
    }

    public CdmiJsonInputStreamEntity(InputStream instream, long length) {
        this.content = instream;
        this.length = length;
        this.transferLen = -1L;
    }

    public boolean isRepeatable() {
        if (this.content == null) {
            return true;
        }
        return this.content.markSupported();
    }

    public long getContentLength() {
        return this.transferLen;
    }

    public long getTransferLength() {
        return this.transferLen;
    }

    public InputStream getContent() throws IOException {
        return this.content;
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public void addField(String key, String value) {
        this.data.put(key, value);
    }

    public void addContent(InputStream content, long length) {
        this.content = content;
        this.length = length;
    }

    private String encodeEntity() {
        this.data.put("metadata", CdmiJsonInputStreamEntity.encodeJson(this.metadata));
        if (this.content != null) {
            this.addField("mimetype", "text/plain");
            this.addField("valuetransferencoding", "utf-8");
        }
        return CdmiJsonInputStreamEntity.encodeJson(this.data);
    }

    private long writePre(OutputStream outstream) throws UnsupportedEncodingException, IOException {
        StringBuffer buffer = new StringBuffer(this.encodeEntity());
        if (this.length > 0L) {
            buffer.replace(buffer.length() - 1, buffer.length(), ",");
            buffer.append(" \"value\": \"");
        }
        byte[] bytes = buffer.toString().getBytes("utf-8");
        outstream.write(bytes);
        return bytes.length;
    }

    private long writePost(OutputStream outstream) throws UnsupportedEncodingException, IOException {
        if (this.length > 0L) {
            StringBuffer buffer = new StringBuffer("\" }");
            byte[] bytes = buffer.toString().getBytes("UTF-8");
            outstream.write(bytes);
            outstream.flush();
            return bytes.length;
        }
        outstream.flush();
        return this.length;
    }

    public boolean isChunked() {
        return false;
    }

    public Header getContentType() {
        return new BasicHeader("Content-Type", "application/cdmi-object");
    }

    private long writeContent(InputStream instream, OutputStream outstream) {
        if (instream == null) {
            return 0L;
        }
        byte[] buffer = new byte[2048];
        long valueLen = 0L;
        try {
            if (this.length < 0L) {
                int l;
                while ((l = instream.read(buffer)) != -1) {
                    outstream.write(buffer, 0, l);
                    valueLen += (long)l;
                }
            } else {
                int l;
                for (long remaining = this.length; remaining > 0L && (l = instream.read(buffer, 0, (int)Math.min(2048L, remaining))) != -1; remaining -= (long)l) {
                    outstream.write(buffer, 0, l);
                    valueLen += (long)l;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return valueLen;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        this.transferLen = 0L;
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream instream = this.content;
        try {
            this.transferLen += this.writePre(outstream);
            this.transferLen += this.writeContent(instream, outstream);
            this.transferLen += this.writePost(outstream);
        }
        finally {
            if (instream != null) {
                instream.close();
            }
        }
    }

    public boolean isStreaming() {
        return true;
    }

    public void consumeContent() throws IOException {
        this.content.close();
    }

    private static String encodeJson(Map<String, String> entries) {
        boolean hasValue = false;
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        for (Map.Entry<String, String> item : entries.entrySet()) {
            if (item.getKey().equals("value")) continue;
            if (item.getKey().equals("metadata")) {
                buffer.append(String.format(" \"%s\": %s,", item.getKey(), item.getValue()));
            } else {
                buffer.append(String.format(" \"%s\": \"%s\",", item.getKey(), item.getValue()));
            }
            hasValue = true;
        }
        if (hasValue) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        buffer.append(" }");
        return buffer.toString();
    }

    public static void main(String[] args) {
        try {
            FileOutputStream out_none = new FileOutputStream(new File("output_none.txt"));
            CdmiJsonInputStreamEntity entity_none = new CdmiJsonInputStreamEntity(null, 1000L);
            entity_none.addMetadata("author", "ywang");
            entity_none.addMetadata("tag", "cdmi");
            entity_none.writeTo(out_none);
            FileInputStream in_file = new FileInputStream(new File("in_file.txt"));
            FileOutputStream out_file = new FileOutputStream(new File("out_file.txt"));
            CdmiJsonInputStreamEntity entity_file = new CdmiJsonInputStreamEntity(in_file, 1024L);
            entity_file.addMetadata("author", "ywang");
            entity_file.addMetadata("tag", "cdmi");
            entity_file.writeTo(out_file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

