#!/bin/bash

set -e

CUR_DIR=$(
  cd $(dirname $0)
  pwd
)
PROJ_DIR=$CUR_DIR/../../

usage() {
  echo -e "Usage: ./$(basename $0)"
  echo -e "     -t <type: release>"
  exit -1
}


function release(){
  git config user.name "semantic-release"
  git config user.email "semantic-release@gitlab"
  pip3 install git+http://gitlab.software.cambricon.com/neuware/platform/python-semantic-release.git --force-reinstall
  old_version=$(cat $PROJ_DIR/version.txt)
  temp_branch=bump-from-${old_version}
  git checkout -b $temp_branch

  export CI_COMMIT_REF_NAME=$temp_branch
  echo "1"
  semantic-release publish
  # new branch
  version=$(cat $PROJ_DIR/version.txt)
  release_branch=release-${version}
  # delete in advance if released before
  git checkout -b $release_branch
  git push origin $release_branch
}


DEL_PYVERSION="3.10"
DEL_TYPE=""
while getopts 't:p' OPT; do
  case $OPT in
  t) DEL_TYPE="$OPTARG" ;;
  p) DEL_PYVERSION="$OPTARG" ;;
  *) usage ;;
  esac
done

pushd $PROJ_DIR
  case $DEL_TYPE in
    check_commit)
      check_commit
      ;;
    check_coverage)
      check_coverage
      ;;
    release)
      release
      ;;
    src_release)
      src_release
      ;;
    *)
      usage
      ;;
  esac
popd
