#! /bin/bash
set -e

CUR_DIR=$(cd `dirname $0`; pwd)
PROJECT_DIR=$CUR_DIR/../..

usage() {
  echo "Usage:"
  echo "    bash test_weekly.sh -s <steps> -m <mode>"
  echo "     <steps>: int variable, train_steps, default value is 50"
  echo "     <mode> must be in [ONLINE, OFFLINE]"
  exit -1
}

while getopts 's:m:' OPT; do
    case $OPT in
        s) STEPS="$OPTARG";;
        m) MODE="$OPTARG";;
        ?) usage
    esac
done

if [[ $STEPS == "" ]];then
    STEPS=50
fi

if [[ $MODE != "ONLINE" ]] && [[ $MODE != "OFFLINE" ]]; then
    usage
fi
echo "mode: $MODE"
echo "steps: $STEPS"

pip install -r $CUR_DIR/requirements.txt


pushd $PROJECT_DIR 
bash tests/demo_tests/pretrain_gpt_1B7_distributed_mlu.sh $STEPS $MODE
bash tests/demo_tests/finetune_llama2_13B_distributed_mlu.sh $STEPS $MODE


python tools/mlu_tools/parse_benchmark.py --platform_mode $MODE
popd


