# 设计目的
为了在Megatron原生特性基础上扩展功能，需要有个接口去独立的重写原生接口内的实现，同时不影响原生代码以及功能，相当与做了一个monkey patch。

# 设计原则
* 不影响社区原逻辑
* 与社区代码隔离
* 模块独立，可单独作为一个组建使用

# 设计需求
* 在社区接口上扩展功能
* 原生接口可快速注册，重写
* 原生接口内部分依然可使用原来实现，通过修饰器形式去扩展功能

# 使用示例
```python
from megatron.function_wrapper import FUNCTION_WRAPPER

@FUNCTION_WRAPPER.register_wrapper(func_name='megatron.training.training.pretrain')
def pretrain_wrapper(self, ...)
    # 通过"megatron.training.training.pretrain"这个key可以获取到原生func的object
    orig_func = FUNCTION_WRAPPER.get_orig_func('megatron.training.training.pretrain')
    #在这个基础上实现重写
    ...
    return out
```
以上代码只是把重写的接口注册上去，但并没有生效，需要调用这个接口才可以生效。
```python
FUNCTION_WRAPPER.func_wrapper_apply()
```
# 在Megatron中扩展功能
在Megatron-LM/megatron/__init__.py中去注册重写函数，并在最后调用FUNCTION_WRAPPER.func_wrapper_apply()，使所有注册全部生效，可以加总开关控制是否使用全部扩展功能，
各个扩展功能模块内部也可以使用开关控制是否使能。
