# Copyright (c) 2023, NVIDIA CORPORATION.  All rights reserved.


MAJOR = 0
MINOR = 6
PATCH = 0
PRE_RELEASE = ''
MLU_MAJOR = 0
MLU_MINOR = 3
MLU_PATCH = 0

# Use the following formatting: (major, minor, patch, pre-release)
VERSION = (MAJOR, MINOR, PATCH, PRE_RELEASE)
MLU_VERSION = (MLU_MAJOR, MLU_MINOR, MLU_PATCH)

__shortversion__ = '.'.join(map(str, VERSION[:3]))
__origin_version__ = '.'.join(map(str, VERSION[:3])) + ''.join(VERSION[3:])
__mlu_version__ = 'mlu' + '.'.join(map(str, MLU_VERSION))
__version__ = __origin_version__ + '+' + __mlu_version__

__package_name__ = 'megatron_core'
__contact_names__ = 'NVIDIA'
__contact_emails__ = 'nemo-toolkit@nvidia.com'  # use NeMo Email
__homepage__ = (
    'https://docs.nvidia.com/deeplearning/nemo/user-guide/docs/en/stable/'  # use NeMo homepage
)
__repository_url__ = 'https://github.com/NVIDIA/Megatron-LM/megatron/core'
__download_url__ = 'https://github.com/NVIDIA/Megatron-LM/releases'
__description__ = (
    'Megatron Core - a library for efficient and scalable training of transformer based models'
)
__license__ = 'BSD-3'
__keywords__ = (
    'deep learning, machine learning, gpu, NLP, NLU, language, transformer, nvidia, pytorch, torch'
)
